\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #4
}


% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Răspunsurile mari"
  subtitle = "Cu vrednicie..."
  subsubtitle = "glasul 5"
  composer = "de Protosinghelul Varlaam"
  arranger = "arm. după N. Lungu"
  %meter = "Andante"
  tagline = ""
}

global = {
  \key f \major
  \time 2/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
}


womenWords = \lyricmode {
  Cu vred -- ni -- ci -- e şi cu drep -- ta -- te
  es -- te a ne în -- chi -- na
  Ta -- tă -- lui şi Fi -- u -- lui şi Sfân -- tu -- lui Duh,
  Tre -- i -- mii ce'i de o __ fi -- in -- ţă
  şi ne -- des păr -- ţi -- tă.
}

menWords = \lyricmode {
  Cu vred -- ni -- ci -- e şi cu drep -- ta -- te
  es -- te a ne în -- chi -- na
  Ta -- tă -- lui şi Fi -- u -- lui şi Sfân -- tu -- lui Duh,
  Tre -- i -- mii ce'i de o fi -- in -- ţă
  şi ne -- des păr -- ţi -- tă.
}

sopMusic = \relative c'' {
  a4^\mf
  a a d( c) b a g f g a b^\>( c8[ b]) a2\!
  f4.^\p e8 d4 cis d2 f4^\markup "cresc..." f f f
  g g g g f( e) f^\< g a2( a8)\! b8\rest
  a4^\f f'2 e d4 c
  b8([ a]) g4 c8^\>([ b a b]) a2\!
  f4^\p f g g a( g f e) d2^\fermata  
  \bar "|." 
}

altMusic = \relative c' {
  f4 f f b( a) g f e f e f g( a8[ g]) f2
  f4. e8 d4 cis d2 f4 f f f
  e e e e f( e) d e f2( f8) b8\rest 
  a4 a( c) c2 b4 a
  g8([ f]) e4 a8([ g f g]) f2
  f4 f e e f( e d cis) d2 
}

tenorMusic = \relative c {
  f4 f f  b( a) g f g a b c c2 c
  f,4. e8 d4 cis d2 f4 f f f
  g g g g a2 a4 b a2( a8) r8 r4 r
  c4^\markup "Tre -" c^\markup "- i -" 
  c^\markup "mii" d c d c c2 c
  f,4 f g g f( e d cis) d2  
}

bassMusic = \relative c {
  f4 f f  b( a) g f e d c c c2 f
  f4. e8 d4 cis d2 f4 f f f
  c c c c f( e) d c f2( f8) r8 r4 r2 r4
  %f f( a) g2 f4 f c4 c c2 f f4 f c c f( e d a) d2  
  a4 b a g8 a b c a([ g f c]) f2
  d4 d c c f( e d \tuplet 3/2 { a8[ b cis]) } d2
 
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>


\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 80
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}
 
\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
} 

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}